/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MissingUnsupportedDependencies
extends KnownCrashReason {
    public MissingUnsupportedDependencies() {
        super(LogType.LOG, LanguageProvider.get((String)"warnings.missing_unsupported_dependencies"), new String[0]);
        this.conflictingReasons.add("CurseForgeCorrupted");
    }

    @Override
    public boolean matches(Log log) {
        if (CrashAssistantApp.gameLaunchedSuccessfully) {
            return false;
        }
        if (!PlatformHelp.isForgeBased()) {
            return false;
        }
        List<String> lines = log.getReader().getAllLinesList();
        ArrayList<String> problemLines = new ArrayList<String>();
        HashSet<String> modIds = new HashSet<String>();
        ArrayList modIdsToJarNames = new ArrayList();
        for (int i = 0; i < lines.size(); ++i) {
            String line2;
            String line = lines.get(i);
            if (!line.contains("Missing or unsupported mandatory dependencies:") && !line.contains("Conflicts between mods:") && !line.contains("Unsupported installed optional dependencies:") && !line.contains("Incompatibilities between mods:") || !line.contains("]: ") || i + 1 >= lines.size() || !MissingUnsupportedDependencies.isMessageLine(lines.get(i + 1))) continue;
            line = line.split("]: ")[1];
            problemLines.add(line);
            for (int j = i + 1; j < lines.size() && MissingUnsupportedDependencies.isMessageLine(line2 = lines.get(j)); ++j) {
                problemLines.add(line2.replaceFirst("^[ \t]+", "&nbsp;&nbsp;&nbsp;&nbsp;"));
                modIds.addAll(MissingUnsupportedDependencies.getModIdsFromLine(line2));
            }
        }
        if (problemLines.isEmpty()) {
            return false;
        }
        this.message = this.message.replace("$LINE_FROM_LOG$", String.join((CharSequence)"\n", problemLines));
        ModListUtils.getCurrentModList((boolean)true).stream().forEach(mod -> {
            if (modIds.contains(mod.getModId())) {
                modIdsToJarNames.add(mod.getModId() + " -> " + mod.getJarName());
            }
        });
        this.message = this.message.replace("$MOD_IDS_TO_JAR_NAMES$", String.join((CharSequence)"\n", modIdsToJarNames));
        return true;
    }

    public static boolean isMessageLine(String line) {
        if (line.isEmpty()) {
            return false;
        }
        char firstChar = line.charAt(0);
        if (firstChar != ' ' && firstChar != '\t') {
            return false;
        }
        return !line.contains("Issues may arise. Continue at your own risk.");
    }

    public static List<String> getModIdsFromLine(String line) {
        ArrayList<String> modIds = new ArrayList<String>();
        String[] splitLine = line.split("'");
        for (int i = 0; i < splitLine.length; ++i) {
            String currentLine = splitLine[i];
            if (!currentLine.endsWith("Mod ID: ") && !currentLine.endsWith("Requested by: ") && !currentLine.endsWith("Mod ") && !currentLine.endsWith("discourages ") || i + 1 >= splitLine.length) continue;
            modIds.add(splitLine[i + 1]);
        }
        return modIds;
    }
}

